<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}


if (!class_exists('Connection')) {

    class Connection
    {
        // protected $host = 'antipolo.ph';
        // protected $username = 'antipolo_acadao';
        // protected $password = '!Antipolo1';
        // protected $database = 'antipolo_acdaps';

        protected $host = 'localhost';
        protected $username = 'root';
        protected $password = 'RoscoITDO';
        protected $database = 'acdaps';


        public $dbConnect;
        function __construct()
        {
            $this->dbConnect = new mysqli($this->host, $this->username, $this->password, $this->database);
            if ($this->dbConnect->connect_errno) {
                die('Failed to connect' . $this->dbConnect->connect_error);

            }
            // echo "Connected";

        }

        public function searchFilter($last_name, $first_name)
        {


            if (isset($_SESSION['All'])) {
                if (empty($last_name) && empty($first_name)) {
                    $query = "SELECT * FROM LDPS";
                }
                $query = "SELECT * FROM LDPS WHERE LastName LIKE ? AND FirstName LIKE ? LIMIT 20";
            } elseif (!isset($_SESSION['All'])) {
                $barangay = $_SESSION['Barangay'];
                $query = "SELECT * FROM LDPS WHERE (LastName LIKE ? AND FirstName LIKE ?) AND AreaOfOperation = '$barangay' LIMIT 20;";
            }

            $last_name = "%$last_name%";
            $first_name = "%$first_name%";


            $stmt = $this->dbConnect->prepare($query);


            $stmt->bind_param("ss", $last_name, $first_name);


            $stmt->execute();


            $result = $stmt->get_result();


            return $result->fetch_all(MYSQLI_ASSOC);

        }

        public function searchFilterUser($last_name, $first_name)
        {


            if (isset($_SESSION['All'])) {
                if (empty($last_name) && empty($first_name)) {
                    $query = "SELECT * FROM LDPS";
                }
                $query = "SELECT * FROM LDPS WHERE (LastName LIKE ? AND FirstName LIKE ?)";

            } elseif (!isset($_SESSION['All'])) {
                $barangay = $_SESSION['Barangay'];
                $query = "SELECT * FROM LDPS WHERE (LastName LIKE ? AND FirstName LIKE ?) AND AreaOfOperation = '$barangay'";
            }

            $query .= "AND ActivityUser = 1";

            $last_name = "%$last_name%";
            $first_name = "%$first_name%";


            $stmt = $this->dbConnect->prepare($query);


            $stmt->bind_param("ss", $last_name, $first_name);


            $stmt->execute();


            $result = $stmt->get_result();


            return $result->fetch_all(MYSQLI_ASSOC);

        }

        public function searchFilterPusher($last_name, $first_name)
        {

            if (isset($_SESSION['All'])) {
                if (empty($last_name) && empty($first_name)) {
                    $query = "SELECT * FROM LDPS";
                }
                $query = "SELECT * FROM LDPS WHERE (LastName LIKE ? AND FirstName LIKE ?)";

            } elseif (!isset($_SESSION['All'])) {
                $barangay = $_SESSION['Barangay'];
                $query = "SELECT * FROM LDPS WHERE (LastName LIKE ? AND FirstName LIKE ?) AND AreaOfOperation = '$barangay'";
            }

            $query .= "AND ActivityPusher = 1";

            $last_name = "%$last_name%";
            $first_name = "%$first_name%";


            $stmt = $this->dbConnect->prepare($query);


            $stmt->bind_param("ss", $last_name, $first_name);


            $stmt->execute();


            $result = $stmt->get_result();


            return $result->fetch_all(MYSQLI_ASSOC);

        }

        public function insertData($post)
        {

            $escape_string = new Login();

            $LastName = ucwords($escape_string->escape_string($_POST['lastname']));
            $FirstName = ucwords($escape_string->escape_string($_POST['firstname']));
            $MiddleName = ucwords($escape_string->escape_string($_POST['middlename']));
            $FullName = $LastName . ", " . $FirstName . " " . $MiddleName;
            $Suffix = ucwords($escape_string->escape_string($_POST['suffix']));
            // $FullName = $escape_string->escape_string($_POST[''));
            $Alias = ucwords($escape_string->escape_string($_POST['alias']));
            $Address = ucwords($escape_string->escape_string($_POST['address']));
            $Hometown = ucwords($escape_string->escape_string($_POST['hometown']));
            $DateOfBirth = empty($_POST['dateofbirth']) ? null : $_POST['dateofbirth'];


            // if (empty($_POST['dateofbirth']) || !isset($_POST['dateofbirth'])) {
            //     $DateOfBirth = "0000-00-00"; // Assign the default value
            //     // $DateOfBirth = STR_TO_DATE('0000-00-00', 'YYYY-MM-DD');
            // } else {
            //     $DateOfBirth = $_POST['dateofbirth']; // Use the user-provided date of birth
            // }
            // $DateOfBirth = date("Y-m-d", strtotime($DateOfBirth)); // Convert the date format
            // $DateOfBirth = date("Y-m-d");

            $PlaceOfBirth = ucwords($escape_string->escape_string($_POST['placeofbirth']));
            $Sex = $escape_string->escape_string($_POST['gender']);
            $Religion = ucwords($escape_string->escape_string($_POST['religion']));
            $CivilStatus = ucwords($escape_string->escape_string($_POST['civilstatus']));
            $Education = ucwords($escape_string->escape_string($_POST['education']));
            $Nationality = ucwords($escape_string->escape_string($_POST['nationality']));
            $ContactNo = $_POST['contactno'];
            $Employment = ucwords($escape_string->escape_string($_POST['employment']));
            $FamilyIncome = $_POST['familyincome'];
            $Father = ucwords($escape_string->escape_string($_POST['father']));
            $Mother = ucwords($escape_string->escape_string($_POST['mother']));
            $Spouse = ucwords($escape_string->escape_string($_POST['spouse']));
            $NoOfChildren = $_POST['noofchildren'];
            $DateSurrendered = $_POST['datesurrendered'];
            $DrugUsed = ucwords($_POST['drugused']);
            if (isset($_SESSION['All'])) {
                $AreaOfOperation = $_POST['areaofoperation'];
            }

            if (isset($_SESSION['Barangay'])) {
                $AreaOfOperation = $_SESSION['Barangay'];
            }
            // $AreaOfOperation = $_POST['areaofoperation'];
            $CaseStatus = $escape_string->escape_string($_POST['casestatus']);

            if (!isset($_POST['user'])) {
                $ActivityUser = 0;
            } else {
                $ActivityUser = $_POST['user'];
            }

            if (!isset($_POST['pusher'])) {
                $ActivityPusher = 0;
            } else {
                $ActivityPusher = $_POST['pusher'];
            }

            $Status = $_POST['status'];

            if (isset($_POST['watchlistedYES'])) {
                $WatchListed = $_POST['watchlistedYES'];
            } elseif (isset($_POST['watchlistedNO'])) {
                $WatchListed = $_POST['watchlistedNO'];
            } elseif (empty($WatchListed)) {
                $WatchListed = 0;
            }

            $Category = $_POST['category'];
            if (!isset($_POST['intervention'])) {
                $Intervention = null;
            } else {
                $Intervention = $_POST['intervention'];
            }
            if (empty($FamilyIncome)) {
                $FamilyIncome = 0;
            }

            if (empty($NoOfChildren)) {
                $NoOfChildren = 0;
            }

            if (!isset($_POST['dateadmitted']) || empty($_POST['dateadmitted'])) {
                $dateadmitted = null;
            } else {
                $dateadmitted = $_POST['dateadmitted'];
            }

            if (!isset($_POST['dategrad']) || empty($_POST['dategrad'])) {
                $dategrad = null;
            } else {
                $dategrad = $_POST['dategrad'];
            }
            $Remarks = ucwords($escape_string->escape_string($_POST['remarks']));


            // $query = "INSERT INTO LDPS (LastName, FirstName, MiddleName, Suffix, FullName, Alias, Address, Hometown, DateOfBirth, PlaceOfBirth, Sex, Religion, CivilStatus, Education, Nationality, ContactNo, Employment, FamilyIncome, Father, Mother, Spouse, NoOfChildren, DateSurrendered, AreaOfOperation, CaseStatus, ActivityUser, ActivityPusher, WatchListed) 
            //          VALUES('$LastName', '$FirstName', '$MiddleName', '$Suffix', '$FullName', '$Alias', '$Address', '$Hometown', '$DateOfBirth', '$PlaceOfBirth', '$Sex', '$Religion', '$CivilStatus', '$Education', '$Nationality', '$ContactNo', '$Employment', '$FamilyIncome', '$Father', '$Mother', '$Spouse', '$NoOfChildren', '$DateSurrendered', 
            //          '$AreaOfOperation', '$CaseStatus', '$ActivityUser', '$ActivityPusher', '$WatchListed')";
            if (!isset($_POST['datesurrendered']) || empty($_POST['datesurrendered'])) {
                $query = "INSERT INTO LDPS (LastName, FirstName, MiddleName, Suffix, FullName, Alias, Address, Hometown, 
            DateOfBirth, PlaceOfBirth, Sex, Religion, CivilStatus, Education, Nationality, ContactNo,
            Employment, FamilyIncome, Father, Mother, Spouse, NoOfChildred, DrugUsed, AreaOfOperation, 
            CaseStatus, ActivityUser, ActivityPusher, Status, WatchListed, Category, Intervention, DateAdmitted, DateGraduated, Remarks) 
            VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";

                $stmt = $this->dbConnect->prepare($query);

                $stmt->bind_param(
                    "ssssssssssssssssssssssssssssssssss",
                    $LastName,
                    $FirstName,
                    $MiddleName,
                    $Suffix,
                    $FullName,
                    $Alias,
                    $Address,
                    $Hometown,
                    $DateOfBirth,
                    $PlaceOfBirth,
                    $Sex,
                    $Religion,
                    $CivilStatus,
                    $Education,
                    $Nationality,
                    $ContactNo,
                    $Employment,
                    $FamilyIncome,
                    $Father,
                    $Mother,
                    $Spouse,
                    $NoOfChildren,
                    $DrugUsed,
                    $AreaOfOperation,
                    $CaseStatus,
                    $ActivityUser,
                    $ActivityPusher,
                    $Status,
                    $WatchListed,
                    $Category,
                    $Intervention,
                    $dateadmitted,
                    $dategrad,
                    $Remarks
                );


            } else {
                $query = "INSERT INTO LDPS (LastName, FirstName, MiddleName, Suffix, FullName, Alias, Address, Hometown, 
            DateOfBirth, PlaceOfBirth, Sex, Religion, CivilStatus, Education, Nationality, ContactNo,
            Employment, FamilyIncome, Father, Mother, Spouse, NoOfChildred, DateSurrendered, DrugUsed, AreaOfOperation, 
            CaseStatus, ActivityUser, ActivityPusher, Status, WatchListed, Category, Intervention, DateAdmitted, DateGraduated, Remarks) 
            VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";


                $stmt = $this->dbConnect->prepare($query);

                $stmt->bind_param(
                    "sssssssssssssssssssssssssssssssssss",
                    $LastName,
                    $FirstName,
                    $MiddleName,
                    $Suffix,
                    $FullName,
                    $Alias,
                    $Address,
                    $Hometown,
                    $DateOfBirth,
                    $PlaceOfBirth,
                    $Sex,
                    $Religion,
                    $CivilStatus,
                    $Education,
                    $Nationality,
                    $ContactNo,
                    $Employment,
                    $FamilyIncome,
                    $Father,
                    $Mother,
                    $Spouse,
                    $NoOfChildren,
                    $DateSurrendered,
                    $DrugUsed,
                    $AreaOfOperation,
                    $CaseStatus,
                    $ActivityUser,
                    $ActivityPusher,
                    $Status,
                    $WatchListed,
                    $Category,
                    $Intervention,
                    $dateadmitted,
                    $dategrad,
                    $Remarks
                );
            }


            // $sql = $this->dbConnect->query($query);
            // if ($stmt->execute()) {
            //     $_SESSION["added"] = true;
            //     header('Location: add.php');
            // }
            // exit();
            // if ($stmt->execute()) {
            //     $ldpsId = $stmt->insert_id;
            //     $intUser = $_SESSION['idno_log'];
            //     $login = new Login();
            //     $login->insertLogs($ldpsId, $intUser, 'New LDPS record inserted');
            //     $_SESSION["added"] = true;
            //     header('Location: add.php');

            // }
            // exit();
            if ($stmt->execute()) {
                $ldpsId = $stmt->insert_id; // Get the new LDPS record ID
                $action = 'CREATE';
                $Login = new Login();
                // Insert a snapshot of the new LDPS record into ldps_logs
                $Login->insertSnapshotLog($ldpsId, $action);

                $_SESSION["added"] = true;
                header('Location: add.php');
                exit(); // good practice to stop further script execution after redirect
            }



        }

        public function showAll()
        {
            $query = "SELECT * FROM LDPS";
            $result = $this->dbConnect->query($query);

            $array = [];
            while ($row = $result->fetch_assoc()) {
                $array[] = $row;
            }

            $dataset = array(
                "draw" => 1,
                // Increment this value for subsequent requests
                "recordsTotal" => count($array),
                "recordsFiltered" => count($array),
                "data" => $array
            );

            return json_encode($dataset);
        }

        public function showAllBarangay()
        {
            $query = "SELECT * FROM barangay";
            $result = $this->dbConnect->query($query);

            $array = [];
            while ($row = $result->fetch_assoc()) {
                $array[] = $row;
            }

            $brgydataset = array(

                "brgy" => $array
            );

            return json_encode($brgydataset);
        }

        public function dataTableSearch($target_barangay)
        {
            $query = "SELECT * FROM LDPS WHERE AreaOfOperation = '$target_barangay'";
            $result = $this->dbConnect->query($query);

            $array = [];
            while ($row = $result->fetch_assoc()) {
                $array[] = $row;
            }

            $dataset = array(
                "draw" => 1,
                // Increment this value for subsequent requests
                "recordsTotal" => count($array),
                "recordsFiltered" => count($array),
                "data" => $array
            );

            return json_encode($dataset);
        }


    }
}

// $new = new Connection();
if (!class_exists('Login')) {
    class Login extends Connection
    {
        public $barangay;
        public $uname;
        public $idno;


        function user_login($username, $password)
        {
            $query = $this->dbConnect->prepare('SELECT * FROM login WHERE UserID = ?');
            $query->bind_param('s', $username);
            $query->execute();
            $result = $query->get_result();

            if ($result->num_rows > 0) {
                $row = $result->fetch_assoc();
                if (strcmp($password, $row['Password']) === 0 && strcmp($username, $row['UserID']) === 0) {
                    $this->barangay = $row['Barangay'];
                    $this->uname = $row['UserID'];
                    $this->idno = $row['ID'];
                    return 'LOGIN SUCCESS';
                } else {
                    if (password_verify($password, $row['Password'])) {
                        // return $row['Barangay'];
                        // session_regenerate_id();
                        $this->barangay = $row['Barangay'];
                        $this->uname = $row['UserID'];
                        $this->idno = $row['ID'];
                        return 'LOGIN SUCCESS';
                    } else {
                        return 'Incorrect Login Credentials';
                    }
                }

            } else {
                return 'User not found';
            }

        }

        public function specific_barangay()
        {
            return $this->barangay;
        }

        public function specific_uname()
        {
            return $this->uname;
        }


        public function escape_string($value)
        {
            return $this->dbConnect->real_escape_string($value);
        }

        public function insertLogs($intRec, $intUser, $string)
        {
            $query = "INSERT INTO LDPS_logs (LDPS_ID, Login_ID, REMARKS) VALUES (?, ?, ?)";
            $stmt = $this->dbConnect->prepare($query);
            $stmt->bind_param('iis', $intRec, $intUser, $string); // 'i' for int, 's' for string

            return $stmt->execute();
        }
        public function getLastInsertId()
        {
            return $this->dbConnect->insert_id;
        }

        public function insertSnapshotLog($ldpsID, $actionType)
        {
            // Helper: Return null if date is empty or invalid
            function sanitizeDate($date)
            {
                return (empty($date) || $date === '0000-00-00') ? null : $date;
            }

            // Ensure session is active
            if (session_status() === PHP_SESSION_NONE) {
                session_start();
            }

            // Ensure UserID is present
            if (!isset($_SESSION['idno_log'])) {
                throw new Exception("User ID not set in session.");
            }

            $userId = $_SESSION['idno_log'];

            // Step 1: Fetch the ldps record
            $query = "SELECT * FROM LDPS WHERE ID = ?";
            $stmt = $this->dbConnect->prepare($query);
            $stmt->bind_param("i", $ldpsID);
            $stmt->execute();
            $result = $stmt->get_result();
            $ldps = $result->fetch_assoc();

            if (!$ldps) {
                return false;
            }

            // Sanitize date fields
            $ldps['DateOfBirth'] = sanitizeDate($ldps['DateOfBirth']);
            $ldps['DateSurrendered'] = sanitizeDate($ldps['DateSurrendered']);
            $ldps['DateAdmitted'] = sanitizeDate($ldps['DateAdmitted']);
            $ldps['DateGraduated'] = sanitizeDate($ldps['DateGraduated']);

            // Step 2: Prepare insert into ldps_logs
            $query = "INSERT INTO LDPS_logs (
  ID, LastName, FirstName, MiddleName, Suffix, FullName, Alias, Address, Hometown, DateOfBirth, 
  PlaceOfBirth, Sex, Religion, CivilStatus, Education, Nationality, ContactNo, Employment, 
  FamilyIncome, Father, Mother, Spouse, NoOfChildred, DateSurrendered, DrugUsed, AreaOfOperation, 
  CaseStatus, ActivityUser, ActivityPusher, WatchListed, Status, Category, Intervention, DateAdmitted, 
  DateGraduated, Remarks, ActionType, UserID
) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";

            $stmt = $this->dbConnect->prepare($query);

            $stmt->bind_param(
                'issssssssssssssssssssssssssssssssssssi', // 1 i + 35 s + 1 i = 37
                $ldps['ID'],
                $ldps['LastName'],
                $ldps['FirstName'],
                $ldps['MiddleName'],
                $ldps['Suffix'],
                $ldps['FullName'],
                $ldps['Alias'],
                $ldps['Address'],
                $ldps['Hometown'],
                $ldps['DateOfBirth'],
                $ldps['PlaceOfBirth'],
                $ldps['Sex'],
                $ldps['Religion'],
                $ldps['CivilStatus'],
                $ldps['Education'],
                $ldps['Nationality'],
                $ldps['ContactNo'],
                $ldps['Employment'],
                $ldps['FamilyIncome'],
                $ldps['Father'],
                $ldps['Mother'],
                $ldps['Spouse'],
                $ldps['NoOfChildred'],
                $ldps['DateSurrendered'],
                $ldps['DrugUsed'],
                $ldps['AreaOfOperation'],
                $ldps['CaseStatus'],
                $ldps['ActivityUser'],
                $ldps['ActivityPusher'],
                $ldps['WatchListed'],
                $ldps['Status'],
                $ldps['Category'],
                $ldps['Intervention'],
                $ldps['DateAdmitted'],
                $ldps['DateGraduated'],
                $ldps['Remarks'],
                $actionType,
                $userId
            );

            return $stmt->execute();
        }



    }

}

if (!class_exists('BarangayList')) {
    class BarangayList extends Connection
    {
        public function barangayDropDown()
        {

            $query = 'SELECT * FROM Barangay';
            $result = $this->dbConnect->query($query);

            $array = [];
            while ($row = $result->fetch_assoc()) {
                $array[] = $row;
            }


            return json_encode($array);

        }

    }
}

if (!class_exists('NationalityList')) {
    class NationalityList extends Connection
    {
        public function nationalityDropDown()
        {
            $query = 'SELECT * FROM Nationality';
            $result = $this->dbConnect->query($query);

            $array = [];
            while ($row = $result->fetch_assoc()) {
                $array[] = $row;
            }

            return json_encode($array);
        }
    }
}

if (!class_exists('CivilStatusList')) {
    class CivilStatusList extends Connection
    {
        public function civilStatusDropdown()
        {
            $query = 'SELECT * FROM CivilStatus';
            $result = $this->dbConnect->query($query);

            $array = [];

            while ($row = $result->fetch_assoc()) {
                $array[] = $row;
            }

            return json_encode($array);
        }
    }
}

if (!class_exists('ReligionList')) {
    class ReligionList extends Connection
    {
        public function religionDropdowns()
        {

            $query = 'SELECT * FROM Religion';
            $result = $this->dbConnect->query($query);

            $array = [];
            while ($row = $result->fetch_assoc()) {
                $array[] = $row;
            }

            return json_encode($array);
        }
    }
}

if (!class_exists('EducationList')) {
    class EducationList extends Connection
    {
        public function educationDropdown()
        {

            $query = 'SELECT * FROM Education';
            $result = $this->dbConnect->query($query);

            $array = [];

            while ($row = $result->fetch_assoc()) {
                $array[] = $row;
            }

            return json_encode($array);
        }

    }
}

if (!class_exists('CategoryList')) {
    class CategoryList extends Connection
    {
        public function categoryDopdown()
        {
            $query = 'SELECT * FROM Category';
            $result = $this->dbConnect->query($query);

            $array = [];

            while ($row = $result->fetch_assoc()) {
                $array[] = $row;
            }
            return json_encode($array);
        }
    }
}


if (!class_exists('InterventionList')) {
    class InterventionList extends Connection
    {
        public function inteventionDropdown()
        {
            $query = 'SELECT * FROM Intervention';
            $result = $this->dbConnect->query($query);

            $array = [];

            while ($row = $result->fetch_assoc()) {
                $array[] = $row;
            }

            return json_encode($array);
        }
    }
}

if (!class_exists('Status')) {
    class Status extends Connection
    {
        public function statusDropdown()
        {
            $query = 'SELECT * FROM Status';
            $result = $this->dbConnect->query($query);
            $array = [];
            while ($row = $result->fetch_assoc()) {
                $array[] = $row;
            }

            return json_encode($array);
        }
    }
}

if (!class_exists('Type')) {
    class Type extends Connection
    {
        public function typeDropdown()
        {
            $query = 'SELECT * FROM Type';
            $result = $this->dbConnect->query($query);
            $array = [];
            while ($row = $result->fetch_assoc()) {
                $array[] = $row;
            }

            return json_encode($array);
        }
    }
}

if (!class_exists('CaseStatusList')) {
    class CaseStatusList extends Connection
    {
        public function caseStatusDropdown()
        {
            $query = 'SELECT * FROM CaseStatus';
            $result = $this->dbConnect->query($query);

            $array = [];

            while ($row = $result->fetch_assoc()) {
                $array[] = $row;
            }

            return json_encode($array);
        }
    }
}

if (!class_exists('AddNewPDEA')) {
    class AddNewPDEA extends Connection
    {
        public function addNewPDEARecord($addnew)
        {

            $real_escape_string = new Login;
            $LastName = ucwords($real_escape_string->escape_string($_POST['lastname']));
            $FirstName = ucwords($real_escape_string->escape_string($_POST['firstname']));
            $MiddleName = ucwords($real_escape_string->escape_string($_POST['middlename']));
            $Suffix = ucwords($real_escape_string->escape_string($_POST['suffix']));
            $Address = ucwords($real_escape_string->escape_string($_POST['address']));


            if (empty($LastName) || empty($FirstName)) {
                $res = [
                    'status' => 422,
                    'message' => "Please fill the required fields."
                ];
                echo json_encode($res);
                return $res;
            }

            // if (isset($_SESSION['All'])) {
            //     $Created_by = $_SESSION['All'];
            // } else {
            //     $Created_by = $_SESSION['Barangay'];
            // }

            $Created_by = $_SESSION['username'];


            if (isset($_SESSION['All'])) {
                $AreaOfOperation = $_POST['areaofoperation'];
            } else if (isset($_SESSION['Barangay'])) {
                $AreaOfOperation = $_SESSION['Barangay'];
            }

            $query = "SELECT * FROM new_record WHERE LastName = ? AND FirstName = ? AND MiddleName = ? AND AreaOfOperation = ?;";
            $stmt = $this->dbConnect->prepare($query);
            $stmt->bind_param('ssss', $LastName, $FirstName, $MiddleName, $AreaOfOperation);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows > 0) {
                $res = [
                    'status' => 412,
                    'message' => 'Data Already Exist'
                ];
                return $res;
            }

            $query = "INSERT INTO new_record (LastName, FirstName, MiddleName, Suffix, AreaOfOperation, Address, created_by)
        VALUES(?, ?, ?, ?, ?, ?, ?)";


            $stmt = $this->dbConnect->prepare($query);
            $stmt->bind_param('sssssss', $LastName, $FirstName, $MiddleName, $Suffix, $AreaOfOperation, $Address, $Created_by);

            if ($stmt->execute()) {
                $res = [
                    'status' => 200,
                    'message' => 'Successfully created'
                ];
                return $res;
            } else {
                $res = [
                    'status' => 500,
                    'message' => 'failed to create'
                ];
                return $res;
            }
        }
    }
}



if (!class_exists('TaggingList')) {
    class TaggingList extends Connection
    {
        public function forTagging()
        {
            if (isset($_SESSION['All'])) {
                $query = "SELECT * FROM new_record WHERE tagged_by IS NULL OR tagged_by = '' ORDER by ID DESC LIMIT 50;";
            } elseif (!isset($_SESSION['All']) && isset($_SESSION['Barangay'])) {
                $barangay = $_SESSION['Barangay'];
                $query = "SELECT * FROM new_record WHERE AreaOfOperation = '$barangay' AND (tagged_by IS NULL OR tagged_by = '') ORDER by ID DESC LIMIT 50;";
            }

            $stmt = $this->dbConnect->query($query);

            if ($stmt->num_rows > 0) {
                $result = $stmt->fetch_all(MYSQLI_ASSOC);

                $res = [
                    'status' => 200,
                    'message' => 'successfully fetched data ',
                    'data' => $result
                ];

                return $res;

            } else {
                $res = [
                    'status' => 500,
                    'message' => 'failed to fetch data'
                ];
                return $res;
            }
            // $result = $stmt->get_result();
        }
    }
}


if (!class_exists('ToAdd')) {
    class ToAdd extends Connection
    {
        public function addToMasterList($id_num)
        {
            $query = "SELECT * FROM new_record WHERE ID = $id_num";
            $stmt = $this->dbConnect->query($query);

            if ($stmt->num_rows === 1) {
                $result = $stmt->fetch_assoc();
                $res = [];
                if (isset($_SESSION['All'])) {
                    $res = [
                        'status' => 200,
                        'message' => 'successfully fetched data',
                        'data' => $result,
                        'editable' => 'yes'
                    ];
                } else {
                    $res = [
                        'status' => 200,
                        'message' => 'successfully fetched data',
                        'data' => $result,
                        'editable' => 'no'
                    ];
                }

                return $res;
            } else {
                $res = [
                    'status' => 500,
                    'message' => 'failed to fetch data'
                ];
                return $res;
            }
        }
    }
}

if (!class_exists('AddToMasterList')) {
    class AddToMasterList extends Connection
    {

        public function updateTag($id)
        {
            $username = $_SESSION['username'];
            $query = "UPDATE new_record SET tagged_by = '$username' WHERE ID = $id";
            $stmt = $this->dbConnect->query($query);
            if ($stmt) {
                $res = [
                    'status' => 200,
                    'message' => 'Tagged!'
                ];
                return $res;
            } else {
                $res = [
                    'status' => 500,
                    'message' => 'Tagging failed'
                ];
                return $res;
            }
        }


        public function addToMasterListDB($post)
        {

            $escape_string = new Login();

            $LastName = ucwords($escape_string->escape_string($_POST['lastname']));
            $FirstName = ucwords($escape_string->escape_string($_POST['firstname']));
            $MiddleName = ucwords($escape_string->escape_string($_POST['middlename']));
            $FullName = $LastName . ", " . $FirstName . " " . $MiddleName;
            $Suffix = ucwords($escape_string->escape_string($_POST['suffix']));
            // $FullName = $escape_string->escape_string($_POST[''));
            $Alias = ucwords($escape_string->escape_string($_POST['alias']));
            $Address = ucwords($escape_string->escape_string($_POST['address']));
            $Hometown = ucwords($escape_string->escape_string($_POST['hometown']));
            $DateOfBirth = $_POST['dateofbirth'] ?? '';
            // $DateOfBirth = date("Y-m-d");
            $PlaceOfBirth = ucwords($escape_string->escape_string($_POST['placeofbirth']));
            $Sex = $escape_string->escape_string($_POST['gender']);
            $Religion = ucwords($escape_string->escape_string($_POST['religion']));
            $CivilStatus = ucwords($escape_string->escape_string($_POST['civilstatus']));
            $Education = ucwords($escape_string->escape_string($_POST['education']));
            $Nationality = ucwords($escape_string->escape_string($_POST['nationality']));
            $ContactNo = $_POST['contactno'];
            $Employment = ucwords($escape_string->escape_string($_POST['employment']));
            $FamilyIncome = $_POST['familyincome'];
            $Father = ucwords($escape_string->escape_string($_POST['father']));
            $Mother = ucwords($escape_string->escape_string($_POST['mother']));
            $Spouse = ucwords($escape_string->escape_string($_POST['spouse']));
            $NoOfChildren = $_POST['noofchildren'];
            $DateSurrendered = $_POST['datesurrendered'];

            if (isset($_SESSION['All'])) {
                $AreaOfOperation = $_POST['areaofoperation'];
            }

            if (isset($_SESSION['Barangay'])) {
                $AreaOfOperation = $_SESSION['Barangay'];
            }
            // $AreaOfOperation = $_POST['areaofoperation'];
            $CaseStatus = $escape_string->escape_string($_POST['casestatus']);

            if (!isset($_POST['user'])) {
                $ActivityUser = 0;
            } else {
                $ActivityUser = $_POST['user'];
            }

            if (!isset($_POST['pusher'])) {
                $ActivityPusher = 0;
            } else {
                $ActivityPusher = $_POST['pusher'];
            }

            $Status = $_POST['status'];

            if (isset($_POST['watchlistedYES'])) {
                $WatchListed = $_POST['watchlistedYES'];
            } elseif (isset($_POST['watchlistedNO'])) {
                $WatchListed = $_POST['watchlistedNO'];
            } elseif (empty($WatchListed)) {
                $WatchListed = 0;
            }

            $Category = $_POST['category'];
            if (!isset($_POST['intervention'])) {
                $Intervention = null;
            } else {
                $Intervention = $_POST['intervention'];
            }
            if (empty($FamilyIncome)) {
                $FamilyIncome = 0;
            }

            if (empty($NoOfChildren)) {
                $NoOfChildren = 0;
            }

            if (!isset($_POST['dateadmitted']) || empty($_POST['dateadmitted'])) {
                $dateadmitted = null;
            } else {
                $dateadmitted = $_POST['dateadmitted'];
            }

            if (!isset($_POST['dategrad']) || empty($_POST['dategrad'])) {
                $dategrad = null;
            } else {
                $dategrad = $_POST['dategrad'];
            }
            $Remarks = ucwords($escape_string->escape_string($_POST['remarks']));


            // $query = "INSERT INTO LDPS (LastName, FirstName, MiddleName, Suffix, FullName, Alias, Address, Hometown, DateOfBirth, PlaceOfBirth, Sex, Religion, CivilStatus, Education, Nationality, ContactNo, Employment, FamilyIncome, Father, Mother, Spouse, NoOfChildren, DateSurrendered, AreaOfOperation, CaseStatus, ActivityUser, ActivityPusher, WatchListed) 
            //          VALUES('$LastName', '$FirstName', '$MiddleName', '$Suffix', '$FullName', '$Alias', '$Address', '$Hometown', '$DateOfBirth', '$PlaceOfBirth', '$Sex', '$Religion', '$CivilStatus', '$Education', '$Nationality', '$ContactNo', '$Employment', '$FamilyIncome', '$Father', '$Mother', '$Spouse', '$NoOfChildren', '$DateSurrendered', 
            //          '$AreaOfOperation', '$CaseStatus', '$ActivityUser', '$ActivityPusher', '$WatchListed')";
            if (!isset($_POST['datesurrendered']) || empty($_POST['datesurrendered'])) {
                $query = "INSERT INTO LDPS (LastName, FirstName, MiddleName, Suffix, FullName, Alias, Address, Hometown, 
            DateOfBirth, PlaceOfBirth, Sex, Religion, CivilStatus, Education, Nationality, ContactNo,
            Employment, FamilyIncome, Father, Mother, Spouse, NoOfChildred, AreaOfOperation, 
            CaseStatus, ActivityUser, ActivityPusher, Status, WatchListed, Category, Intervention, DateAdmitted, DateGraduated, Remarks) 
            VALUES(?, ?, ?, ?, ?, ?, ?, ?, NULLIF(?, ''), ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";

                $stmt = $this->dbConnect->prepare($query);

                $stmt->bind_param(
                    "sssssssssssssssssssssssssssssssss",
                    $LastName,
                    $FirstName,
                    $MiddleName,
                    $Suffix,
                    $FullName,
                    $Alias,
                    $Address,
                    $Hometown,
                    $DateOfBirth,
                    $PlaceOfBirth,
                    $Sex,
                    $Religion,
                    $CivilStatus,
                    $Education,
                    $Nationality,
                    $ContactNo,
                    $Employment,
                    $FamilyIncome,
                    $Father,
                    $Mother,
                    $Spouse,
                    $NoOfChildren,
                    $AreaOfOperation,
                    $CaseStatus,
                    $ActivityUser,
                    $ActivityPusher,
                    $Status,
                    $WatchListed,
                    $Category,
                    $Intervention,
                    $dateadmitted,
                    $dategrad,
                    $Remarks

                );


            } else {
                $query = "INSERT INTO LDPS (LastName, FirstName, MiddleName, Suffix, FullName, Alias, Address, Hometown, 
            DateOfBirth, PlaceOfBirth, Sex, Religion, CivilStatus, Education, Nationality, ContactNo,
            Employment, FamilyIncome, Father, Mother, Spouse, NoOfChildred, DateSurrendered, AreaOfOperation, 
            CaseStatus, ActivityUser, ActivityPusher, Status, WatchListed, Category, Intervention, DateAdmitted, DateGraduated, Remarks) 
            VALUES(?, ?, ?, ?, ?, ?, ?, ?, NULLIF(?, ''), ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";


                $stmt = $this->dbConnect->prepare($query);

                $stmt->bind_param(
                    "ssssssssssssssssssssssssssssssssss",
                    $LastName,
                    $FirstName,
                    $MiddleName,
                    $Suffix,
                    $FullName,
                    $Alias,
                    $Address,
                    $Hometown,
                    $DateOfBirth,
                    $PlaceOfBirth,
                    $Sex,
                    $Religion,
                    $CivilStatus,
                    $Education,
                    $Nationality,
                    $ContactNo,
                    $Employment,
                    $FamilyIncome,
                    $Father,
                    $Mother,
                    $Spouse,
                    $NoOfChildren,
                    $DateSurrendered,
                    $AreaOfOperation,
                    $CaseStatus,
                    $ActivityUser,
                    $ActivityPusher,
                    $Status,
                    $WatchListed,
                    $Category,
                    $Intervention,
                    $dateadmitted,
                    $dategrad,
                    $Remarks
                );
            }


            // $sql = $this->dbConnect->query($query);
            // if ($stmt->execute()) {
            //     $ldpsId = $stmt->insert_id;
            //     $intUser = $_SESSION['idno_log'];
            //     $login = new Login();
            //     $login->insertLogs($ldpsId, $intUser, 'New LDPS record inserted from inqury');

            //     $res = [
            //         'status' => 200,
            //         'message' => 'Successfully Added'
            //     ];
            //     return $res;
            // } else {
            //     $res = [
            //         'status' => 500,
            //         'message' => 'failed to create'
            //     ];
            //     return $res;
            // }
            if ($stmt->execute()) {
                $ldpsId = $stmt->insert_id;
                $login = new Login();
                $login->insertSnapshotLog($ldpsId, 'CREATE');

                $res = [
                    'status' => 200,
                    'message' => 'Successfully Added'
                ];
                return $res;
            } else {
                $res = [
                    'status' => 500,
                    'message' => 'Failed to create'
                ];
                return $res;
            }




        }

    }
}

if (!class_exists('AddIntervention')) {
    class AddIntervention extends Connection
    {
        public function addNewInt($post)
        {
            $ldps_id = $_POST['ldps_id'];
            $Intervention = $_POST['intervention'];
            $DateAdmitted = $_POST['dateadmitted'];

            if (!isset($_POST['dategrad']) || empty($_POST['dategrad'])) {
                $DateGraduated = null;
            } else {
                $DateGraduated = $_POST['dategrad'];
            }
            $query = "INSERT INTO add_intervention (ldps_id, Intervention, DateAdmitted, DateGraduated) VALUES (?,?,?,?)";
            $stmt = $this->dbConnect->prepare($query);
            $stmt->bind_param("ssss", $ldps_id, $Intervention, $DateAdmitted, $DateGraduated);
            if ($stmt->execute()) {
                $res = [
                    'status' => 200,
                    'message' => 'Successfully Added Intervention'
                ];
                return $res;
            } else {
                $res = [
                    'status' => 500,
                    'message' => 'failed to create'
                ];
                return $res;
            }
        }
    }
}

if (!class_exists('AllInterventions')) {
    class AllInterventions extends Connection
    {
        public function interventionsLists($id)
        {
            $query = "SELECT * FROM add_intervention 
        LEFT JOIN Intervention 
        ON add_intervention.Intervention = Intervention.intervention_id 
        WHERE ldps_id = $id ORDER BY ID DESC";

            $stmt = $this->dbConnect->query($query);

            if ($stmt->num_rows > 0) {
                $result = $stmt->fetch_all(MYSQLI_ASSOC);

                $res = [
                    'status' => 200,
                    'message' => 'successfully fetched data ',
                    'data' => $result
                ];

                return $res;

            } else {
                $res = [
                    'status' => 500,
                    'message' => 'failed to fetch data'
                ];
                return $res;
            }
        }
    }
}


if (!class_exists('UpdtAddInt')) {
    class UpdtAddInt extends Connection
    {



        public function updateInt()
        {
            $id = $_POST['id'];
            $Intervention = $_POST['intervention'];

            if (!isset($_POST['dateadmitted']) || empty($_POST['dateadmitted'])) {
                $DateAdmitted = null;
            } else {
                $DateAdmitted = $_POST['dateadmitted'];
            }

            if (!isset($_POST['dategrad']) || empty($_POST['dategrad'])) {
                $DateGraduated = null;
            } else {
                $DateGraduated = $_POST['dategrad'];
            }




            $query = "UPDATE add_intervention SET Intervention = ?, DateAdmitted = ?, DateGraduated = ? WHERE ID = $id;";
            $stmt = $this->dbConnect->prepare($query);

            $stmt->bind_param('sss', $Intervention, $DateAdmitted, $DateGraduated);

            if ($stmt->execute()) {
                $res = [
                    'status' => 200,
                    'message' => 'Additional intervention updated successfully'
                ];

                return $res;
            } else {
                $res = [
                    'status' => 500,
                    'message' => 'Failed to update additional intervention'
                ];
                return $res;
            }
        }
    }
}


if (!class_exists('Report')) {
    class Report extends Connection
    {
        public function listofgrads()
        {
            $query = "SELECT LDPS.*,
            intervention1.intervention_name AS Intervention_Name,
            CivilStatus.civil_status_name AS Civil_Status,
            Education.educational_attainment_name AS Educational_Attainment,
            Religion.religion_name AS Religion,
            Nationality.nationality_name AS Nationality,
            Category.category_name AS Category,
            Status.status_name AS Status,
            add_intervention.Intervention AS Added_Intervention_ID,
            intervention2.intervention_name AS Added_Intervention_Name,
            add_intervention.DateAdmitted AS Added_Date_Admitted,
            add_intervention.DateGraduated AS Added_Date_Graduated
        FROM LDPS
        LEFT JOIN Intervention AS intervention1
        ON LDPS.Intervention = intervention1.intervention_id
        LEFT JOIN add_intervention
        ON LDPS.ID = add_intervention.ldps_id
        LEFT JOIN Intervention AS intervention2
        ON add_intervention.Intervention = intervention2.intervention_id
        LEFT JOIN CivilStatus
        ON LDPS.CivilStatus = CivilStatus.civil_status_id
        LEFT JOIN Education
        ON LDPS.Education = Education.educational_attainment_id
        LEFT JOIN Religion
        ON LDPS.Religion = Religion.religion_id
        LEFT JOIN Nationality
        ON LDPS.Nationality = Nationality.nationality_id
        LEFT JOIN Category
        ON LDPS.Category = Category.category_id
        LEFT JOIN Status
        ON LDPS.Status = Status.status_id";
            if (isset($_SESSION['All'])) {
                $query .= " WHERE (LDPS.ID = add_intervention.DateGraduated IS NOT NULL) OR LDPS.DateGraduated IS NOT NULL";
            }
            if (!isset($_SESSION['All']) && isset($_SESSION['Barangay'])) {
                $barangay = $_SESSION['Barangay'];
                $query .= " WHERE (LDPS.ID = add_intervention.DateGraduated IS NOT NULL OR LDPS.DateGraduated IS NOT NULL) AND LDPS.AreaOfOperation = '$barangay';";
            }


            $result = $this->dbConnect->query($query);
            if (!$result) {
                die("Query failed: " . mysqli_error($this->dbConnect));
            }

            $array = [];
            while ($row = $result->fetch_assoc()) {
                $array[] = $row;
            }
            $dataset = array(
                "recordsTotal" => count($array),
                "data" => $array
            );

            return json_encode($dataset);
        }

        public function enrolled()
        {
            $query = "SELECT LDPS.*,
            intervention1.intervention_name AS Intervention_Name,
            CivilStatus.civil_status_name AS Civil_Status,
            Education.educational_attainment_name AS Educational_Attainment,
            Religion.religion_name AS Religion,
            Nationality.nationality_name AS Nationality,
            Category.category_name AS Category,
            Status.status_name AS Status,
            add_intervention.Intervention AS Added_Intervention_ID,
            intervention2.intervention_name AS Added_Intervention_Name,
            add_intervention.DateAdmitted AS Added_Date_Admitted,
            add_intervention.DateGraduated AS Added_Date_Graduated
        FROM LDPS
        LEFT JOIN Intervention AS intervention1
        ON LDPS.Intervention = intervention1.intervention_id
        LEFT JOIN add_intervention
        ON LDPS.ID = add_intervention.ldps_id
        LEFT JOIN Intervention AS intervention2
        ON add_intervention.Intervention = intervention2.intervention_id
        LEFT JOIN CivilStatus
        ON LDPS.CivilStatus = CivilStatus.civil_status_id
        LEFT JOIN Education
        ON LDPS.Education = Education.educational_attainment_id
        LEFT JOIN Religion
        ON LDPS.Religion = Religion.religion_id
        LEFT JOIN Nationality
        ON LDPS.Nationality = Nationality.nationality_id
        LEFT JOIN Category
        ON LDPS.Category = Category.category_id
        LEFT JOIN Status
        ON LDPS.Status = Status.status_id";

            if (isset($_SESSION['All'])) {
                $query .= " WHERE (LDPS.ID = add_intervention.DateGraduated IS NULL AND LDPS.DateGraduated IS NULL) AND (LDPS.DateAdmitted IS NOT NULL OR add_intervention.DateAdmitted IS NOT NULL);";
            }
            if (!isset($_SESSION['All']) && isset($_SESSION['Barangay'])) {
                $barangay = $_SESSION['Barangay'];
                $query .= " WHERE (LDPS.ID = add_intervention.DateGraduated IS NULL AND LDPS.DateGraduated IS NULL) AND (add_intervention.DateAdmitted IS NOT NULL OR LDPS.DateAdmitted IS NOT NULL) AND AreaOfOperation = '$barangay';";
            }


            $result = $this->dbConnect->query($query);
            if (!$result) {
                die("Query failed: " . mysqli_error($this->dbConnect));
            }

            $array = [];
            while ($row = $result->fetch_assoc()) {
                $array[] = $row;
            }
            $dataset = array(
                "recordsTotal" => count($array),
                "data" => $array
            );

            return json_encode($dataset);
        }

        public function allRecords()
        {
            $query = "SELECT LDPS.*,
            intervention1.intervention_name AS Intervention_Name,
            CivilStatus.civil_status_name AS Civil_Status,
            Education.educational_attainment_name AS Educational_Attainment,
            Religion.religion_name AS Religion,
            Nationality.nationality_name AS Nationality,
            Category.category_name AS Category,
            Status.status_name AS Status,
            add_intervention.Intervention AS Added_Intervention_ID,
            intervention2.intervention_name AS Added_Intervention_Name,
            add_intervention.DateAdmitted AS Added_Date_Admitted,
            add_intervention.DateGraduated AS Added_Date_Graduated
        FROM LDPS
        LEFT JOIN Intervention AS intervention1
        ON LDPS.Intervention = intervention1.intervention_id
        LEFT JOIN add_intervention
        ON LDPS.ID = add_intervention.ldps_id
        LEFT JOIN Intervention AS intervention2
        ON add_intervention.Intervention = intervention2.intervention_id
        LEFT JOIN CivilStatus
        ON LDPS.CivilStatus = CivilStatus.civil_status_id
        LEFT JOIN Education
        ON LDPS.Education = Education.educational_attainment_id
        LEFT JOIN Religion
        ON LDPS.Religion = Religion.religion_id
        LEFT JOIN Nationality
        ON LDPS.Nationality = Nationality.nationality_id
        LEFT JOIN Category
        ON LDPS.Category = Category.category_id
        LEFT JOIN Status
        ON LDPS.Status = Status.status_id";

            if (!isset($_SESSION['All']) && isset($_SESSION['Barangay'])) {
                $barangay = $_SESSION['Barangay'];
                $query .= " WHERE AreaOfOperation = '$barangay';";
            }


            $result = $this->dbConnect->query($query);

            $array = [];
            while ($row = $result->fetch_assoc()) {
                $array[] = $row;
            }
            $dataset = array(
                "recordsTotal" => count($array),
                "data" => $array
            );

            return json_encode($dataset);
        }

    }
}

if (!class_exists('ChangePassword')) {
    class ChangePassword extends Login
    {
        public function changepass($post)
        {
            $real_escape_string = new Login();



            $oldPass = $real_escape_string->escape_string($_POST['old_password']);
            $newPass = $real_escape_string->escape_string($_POST['new_password']);
            $confirmPass = $real_escape_string->escape_string($_POST['confirm_new_password']);


            $query = "SELECT * FROM login WHERE ID = '" . $_SESSION['idno_log'] . "' AND UserID = '" . $_SESSION['username_log'] . "';";
            // $query = "SELECT * FROM login WHERE ID = '{$_SESSION['idno_log']}' AND UserID = '{$_SESSION['username_log']}';";
            $stmt = $this->dbConnect->prepare($query);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows > 0) {
                $row = $result->fetch_assoc();
                if (strcmp($oldPass, $row['Password']) !== 0) {
                    if (password_verify($oldPass, $row['Password'])) {
                        if (strcmp($newPass, $confirmPass) !== 0) {
                            $res = [
                                'status' => 400,
                                'message' => "New Password Not Match"
                            ];
                        } else {
                            $hashed_password = password_hash($confirmPass, PASSWORD_DEFAULT);
                            $query = "UPDATE login SET Password = '$hashed_password' WHERE ID = '" . $_SESSION['idno_log'] . "'";
                            $stmt = $this->dbConnect->query($query);
                            if ($stmt) {
                                $res = [
                                    'status' => 200,
                                    'message' => "Password Successfully Changed"
                                ];
                            }
                        }

                    } else {
                        $res = [
                            'status' => 401,
                            'message' => "Incorrect Old Password"
                        ];
                    }

                } else {
                    if (strcmp($newPass, $confirmPass) !== 0) {
                        $res = [
                            'status' => 400,
                            'message' => "New Password Not Match"
                        ];
                    } else {
                        $hashed_password = password_hash($confirmPass, PASSWORD_DEFAULT);
                        $query = "UPDATE login SET Password = '$hashed_password' WHERE ID = '" . $_SESSION['idno_log'] . "'";
                        $stmt = $this->dbConnect->query($query);
                        if ($stmt) {
                            $res = [
                                'status' => 200,
                                'message' => "Password Successfully Changed"
                            ];
                        }

                    }

                }

            }
            return $res;
        }
    }
}

if (!class_exists('PWUDDashBoard')) {
    class PWUDDashBoard extends Connection
    {

        public function pwudDashboardCount($get)
        {
            $datefrom = $get['datefrom'];
            $dateuntil = $get['dateuntil'];

            if (!$datefrom || !$dateuntil) {
                return json_encode(['error' => 'Missing date range']);
            }

            $query = "SELECT
                    CASE
                        WHEN DateOfBirth IS NULL THEN 'Unknown'
                        WHEN age BETWEEN 0 AND 11 THEN '0-11'
                        WHEN age BETWEEN 12 AND 15 THEN '12-15'
                        WHEN age BETWEEN 16 AND 20 THEN '16-20'
                        WHEN age BETWEEN 21 AND 25 THEN '21-25'
                        WHEN age BETWEEN 26 AND 30 THEN '26-30'
                        ELSE 'Other'
                    END AS age_group,

                    -- Sum all non-null categorized entries
                    SUM(CASE WHEN ActivityUser = 1 AND ActivityPusher = 0 THEN 1 ELSE 0 END) AS user_only,
                    SUM(CASE WHEN ActivityUser = 0 AND ActivityPusher = 1 THEN 1 ELSE 0 END) AS pusher_only,
                    SUM(CASE WHEN ActivityUser = 1 AND ActivityPusher = 1 THEN 1 ELSE 0 END) AS both_user_pusher,
                    SUM(CASE WHEN ActivityUser = 0 AND ActivityPusher = 0 THEN 1 ELSE 0 END) AS neither,

                    -- Corrected total (excluding NULLs from groupings)
                    COUNT(*) AS total

                    FROM (
                    SELECT
                        DateOfBirth,
                        ROUND(DATEDIFF(CURDATE(), DateOfBirth) / 365) AS age,
                        DateSurrendered,
                        ActivityUser,
                        ActivityPusher
                    FROM LDPS
                    WHERE DateSurrendered BETWEEN '$datefrom' AND '$dateuntil'
                    ) AS sub
                    GROUP BY age_group
                    ORDER BY age_group;";



            $result = $this->dbConnect->query($query);
            $data = [];

            $data = [];
            while ($row = $result->fetch_assoc()) {
                $data[] = $row;
            }
            return $data;

        }
        public function pwudTotalCount($get)
        {
            $datefrom = $get['datefrom'] ?? null;
            $dateuntil = $get['dateuntil'] ?? null;

            if (!$datefrom || !$dateuntil) {
                return json_encode(['error' => 'Missing date range']);
            }
            $query = "SELECT COUNT(*) AS total
                FROM LDPS
                WHERE DateSurrendered BETWEEN '$datefrom' AND '$dateuntil'";



            $result = $this->dbConnect->query($query);
            $data = [];

            $data = [];
            while ($row = $result->fetch_assoc()) {
                $data[] = $row;
            }
            return $data;

        }
    }
}