let getID;
let int_id;


const table = () => {

    $.ajax({
        type: "GET",
        url: "../includes/forTaggingLists.php",
        success: (response) => {
            let res = JSON.parse(response);
            if (res.status == 200) {
                // console.log("success");
                // console.log(res.message);

                let data = res.data; // Assuming res.data is an array of objects

                // Get a reference to the table body element
                if ($.fn.DataTable.isDataTable('#data-table')) {
                    $('#data-table').DataTable().destroy();
                }

                let tableBody = $('#data-table tbody');

                // Clear any existing content in the table body
                tableBody.empty();

                // Iterate through the data array and populate the table
                data.forEach(item => {
                    let row = `
                        <tr>
                            <td>${item.LastName}</td>
                            <td>${item.FirstName}</td>
                            <td>${item.MiddleName}</td>
                            <td>${item.AreaOfOperation}</td>
                            <td>
                            <button class="btn btn-link p-0 tag" type="button" value="${item.ID}">
                              <i class="bi bi-tag" style="font-size: 1.3em;"></i>
                            </button>
                            </td>
                        </tr>
                    `;
                    tableBody.append(row);
                });

                // $("#data-table").DataTable().destroy();
                $('#data-table').DataTable();

            }
        },
        "error": function (xhr, error, thrown) {
            console.log("AJAX error:", xhr.responseText);
        }
    });

}

const existingint = (id) => {
    let formbody;
    $.ajax({
        type: "GET",
        url: "../includes/process.php?add_int_id=" + id,
        success: (response) => {
            let res = JSON.parse(response);
            if (res.status == 200) {
                // console.log(int_id);
                // console.log(res.status);

                let data = res.data;
                formbody = $('#allint');
                formbody.empty();

                data.forEach(item => {
                    let DA;
                    let DG;

                    if (item.DateAdmitted == null) {
                        DA = ''
                    } else {
                        DA = item.DateAdmitted
                    }

                    if (item.DateGraduated == null) {
                        DG = ''
                    } else {
                        DG = item.DateGraduated
                    }
                    let fields = ` <form class="row" id="updtint">
                                    <input type="hidden" name="id" id="id" value="${item.ID}">
                                    <div class="col-md-5">
                                        <select class="form-select pt-0" name="intervention" id="intervention_r" data-search="true"
                                            required>
                                            <option value="${item.intervention_id}" selected hidden>${item.intervention_name}</option>
                                        </select>
                                    </div> 
                                    <div class="col-md-3">
                           
                                            <input type="date" value="${DA}" class="form-control" style="text-transform: lowercase;" id="dateadmitted"
                                            name="dateadmitted" min="2000-01-01" required>
                                    
                                    </div>
                                    <div class="col-md-3">
                           
                                    <input type="date" value="${DG}" class="form-control" style="text-transform: lowercase;" id="dategrad"
                                        name="dategrad" min="2000-01-01">
                            
                                    </div>
                                    <div class="col-md-1">
                            
                                        <button class="btn btn-link form-control d-flex flex-column justify-content-center align-items-center" type="submit" id="updtaddintbtn" value="${item.ID}">
                                            <i class="bi bi-pencil-square" style="font-size: 1.5em;"></i>
                                        </button>
                                        
                                    </div> 
                                    </form>
                                    <hr class="p-0" style="border: none;">
                                    
                                    <script>
                                    $(document).ready(function () {
                                        $.get('../includes/interventionLists.php', data => {
                                            let options = JSON.parse(data);
                                            let dropdown = $('#intervention_r');
                                            $.each(options, (index, option) => {
                                                dropdown.append($('<option />').val(option.value).text(option.text))
                                            });
                                        });
                                    });
                                    </script>`;
                    // console.log(item.ID);
                    formbody.append(fields);
                });
            } else if (res.status == 500) {
                // console.log(res.status);
                formbody = $('#allint');
                formbody.empty();


            }
        }
    })
}



$(document).ready(function () {
    // Get references to the checkboxes
    let checkboxYes = $('#watchlistedYes');
    let checkboxNo = $('#watchlistedNo');

    // Attach click event handlers
    checkboxYes.on('click', function () {
        if (checkboxYes.is(':checked')) {
            checkboxNo.prop('checked', false);
        }
    });

    checkboxNo.on('click', function () {
        if (checkboxNo.is(':checked')) {
            checkboxYes.prop('checked', false);
        }
    });

    if ($('#data-table').length > 0) {
        table();
    }

    $('#editRecordModal').on('hidden.bs.modal', function () {
        $(this).find('form').trigger('reset');

        // $('#search').click();

    })

    $('#intervention_r').text('');

    // $('#addtlintmo').on('hidden.bs.modal', function () {
    //     $(this).find('$(#allint)').trigger('reset');
    // })


    // $.ajax({
    //     type: "GET",
    //     url: "../includes/forTaggingLists.php",
    //     success: (response) => {
    //         let res = JSON.parse(response);
    //         if(res.status == 200){
    //             console.log("success");
    //         }
    //     }

    // });
    // $("#changePass").click(function (event) {
    //     // Prevent the default behavior of the link
    //     event.preventDefault();

    //     // Manipulate the URL
    //     var newURL = "http://localhost/ACADAO BACKUP-GIT/ACADAO_BACKUP/view/changepass.php"; // Modify the URL as per your requirement

    //     // Redirect to the new URL
    //     window.location.href = newURL;
    // });

});

// ===== //


$(document).on('click', '.updateRecord', function () {

    var id_num = $(this).val();

    $.ajax({
        type: "GET",
        url: "../includes/process.php?id_num=" + id_num,
        success: function (response) {

            let res = JSON.parse(response);
            if (res.status == 404) {

                alert(res.message);
            } else if (res.status == 200) {

                // console.log(res.data.CaseStatus);

                $('#id').val(res.data.ID);
                $('#lastname').val(res.data.LastName);
                $('#firstname').val(res.data.FirstName);
                $('#middlename').val(res.data.MiddleName);
                $('#suffix').val(res.data.Suffix);
                $('#alias').val(res.data.Alias);
                $('#dateofbirth').val(res.data.DateOfBirth);
                $('#placeofbirth').val(res.data.PlaceOfBirth);
                $('#gender').val(res.data.Sex);
                // $('#nationality').val(res.data.Nationality);
                $('#nationality').append($('<option />').val(res.data.nationality_id).text(res.data.nationality_name).prop('selected', true).prop('hidden', true));
                // $('#religion').val(res.data.religion_name)
                $('#religion').append($('<option />').val(res.data.religion_id).text(res.data.religion_name).prop('selected', true).prop('hidden', true));
                $('#address').val(res.data.Address);
                // $('#areaofoperation').val(res.data.AreaOfOperation);
                $('#drugused').val(res.data.DrugUsed);
                $('#areaofoperation').append($('<option />').val(res.data.AreaOfOperation).text(res.data.AreaOfOperation).prop('selected', true).prop("hidden", true));
                $('#hometown').val(res.data.Hometown);
                // $('#civilstatus').val(res.data.civil_status_name)
                $('#civilstatus').append($('<option />').val(res.data.civil_status_id).text(res.data.civil_status_name).prop('selected', true).prop('hidden', true));
                $('#contactno').val(res.data.ContactNo);
                $('#noofchildren').val(res.data.NoOfChildren);
                // $('#education').val(res.data.Education);
                $('#education').append($('<option />').val(res.data.educational_attainment_id).text(res.data.educational_attainment_name).prop('selected', true).prop('hidden', true));
                $('#employment').val(res.data.Employment);
                $('#familyincome').val(res.data.FamilyIncome);
                // $('#inputCity').val(res.data.InputCity);
                $('#spouse').val(res.data.Spouse);
                $('#father').val(res.data.Father);
                $('#mother').val(res.data.Mother);
                $('#datesurrendered').val(res.data.DateSurrendered);
                if ($('#datesurrendered').length > 0) {


                    $('#casestatus').append($('<option />').val('Voluntary Surrender').text('Voluntary Surrender').prop('selected', true).prop('hidden', true));
                } else {

                    $('#casestatus').val(res.data.CaseStatus);
                }

                // $('#casestatus').append($('<option />').val(res.data.CaseStatus).text(res.data.CaseStatus).prop('selected', true).prop('hidden', true));

                //here
                if (res.data.ActivityUser == 1) {
                    $('#user').val(res.data.ActivityUser).prop('checked', true);
                    // $('#pusher').val(res.data.ActivityPusher).prop('checked', true);
                }
                if (res.data.ActivityPusher == 1) {
                    $('#pusher').val(res.data.ActivityPusher).prop('checked', true);
                }

                // $('#status').val(res.data.status_name);
                if (res.data.Status === '') {
                    $('#status').append($('<option />').val('').text('Choose...').prop('selected', true).prop('hidden', true));
                } else if (res.data.Status === null) {
                    $('#status').append($('<option />').val('').text('Choose...').prop('selected', true).prop('hidden', true));
                } else {
                    $('#status').append($('<option />').val(res.data.status_id).text(res.data.status_name).prop('selected', true).prop('hidden', true));
                }



                if (res.data.WatchListed == 1) {
                    $('#watchlistedYes').val(res.data.WatchListed).prop('checked', true);
                    $('#wly').css("color", "red");
                } else if (res.data.WatchListed == 0) {
                    $('#watchlistedNo').val(res.data.WatchListed).prop('checked', true);
                    $('#wly').css("color", "black");
                }
                $('#category').append($('<option />').val(res.data.category_id).text(res.data.category_name).prop('selected', true).prop('hidden', true));
                if (res.data.category_name == 'Deceased' || res.data.category_name == 'Cannot be located') {
                    $('#intervention').append($('<option />').val('').text('NOT APPLICABLE').prop('selected', true).prop('hidden', true)).prop('disabled', true);
                    $('#dateadmitted').val('mm/dd/yyyy').prop('disabled', true);
                    $('#dategrad').val('mm/dd/yyyy').prop('disabled', true);

                } else {
                    $('#intervention').append(($('<option />')).val(res.data.intervention_id).text(res.data.intervention_name).prop('selected', true).prop('hidden', true)).prop('disabled', false);
                    $('#dateadmitted').val(res.data.DateAdmitted);
                    $('#dategrad').val(res.data.DateGraduated);
                }
                   $('#remarks').val(res.data.Remarks);
                $('#addint').val(res.data.ID);
                $('#ldps_id').val(res.data.ID);
                $('#addtlintbtn').val(res.data.ID);
             
                $('#editRecordModal').modal('show');

                $('#editRecordModal').on('hidden.bs.modal', function () {
                    // Clear all the fields
                    // $('input:not([type=hidden]),textarea,select').val('');
                    // Also, reset the checked state of the checkboxes and radio buttons
                    $('input[type=checkbox], input[type=radio]').prop('checked', false);
                });

            }

        }
    });

});

$(document).on('submit', '#updateFormRecord', function (e) {
    e.preventDefault();
    var formData = new FormData(this);
    formData.append("update_record", true);

    $.ajax({
        type: "POST",
        url: "../includes/process.php",
        data: formData,
        processData: false,
        contentType: false,
        success: function (response) {

            let res = JSON.parse(response);

            if (res.status == 422) {
                $('#errorMessageUpdate').removeClass('d-none');
                $('#errorMessageUpdate').text(res.message);
            } else if (res.status == 200) {
                // console.log('success');
                alertify.set('notifier', 'position', 'top-right');
                alertify.success(res.message);
                $('#errorMessageUpdate').addClass('d-none');
                // $('#editRecordModal').modal('hide');
                $('#updateFormRecord')[0].reset();

                // $('#myTable').load(location.href + " #myTable");
                Swal.fire({
                    position: 'center',
                    icon: 'success',
                    title: 'Successfully Updated',
                    // confirmButtonText: 'Ok',
                    showConfirmButton: false,
                    timer: 1000
                }).then((result) => {
                    if (result.isConfirmed) {
                        $('#search').click();
                    }
                });
                $('#editRecordModal').modal('hide');

            } else if (res.status == 500) {
                alert(res.message);

            }
        }

    });

});

$(document).on('submit', '#addnew', function (e) {
    e.preventDefault();

    let formData = new FormData(this);
    formData.append('add_new_pdea', true);

    $.ajax({
        type: "POST",
        url: "../includes/process.php",
        data: formData,
        processData: false,
        contentType: false,

        success: function (response) {
            let res = jQuery.parseJSON(response);
            // console.log(res.message);
            if (res.status == 412) {
                // console.log("already exist")
                alertify.set('notifier', 'position', 'top-right');
                alertify.error(res.message);

            }
            if (res.status == 200) {
                alertify.set('notifier', 'position', 'top-right');
                alertify.success(res.message);
                table();
                $('#addnew')[0].reset();
            }
        }
    })
});

// $("#editRecordModal").on('hide.bs.modal', function () {
//     alert('The modal is about to be hidden.');
// });


// $(document).ready(() => {
//     $.ajax({
//         type: "GET",
//         url: "../includes/process.php",
//         success: (response) => {
//             let res = JSON.parse(response);
//             if (res.status == 200) {
//                 console.log("success");
//                 // $('ul').append(res.data.LastName);

//             }
//         }

//     })
// })

$(document).on('click', '.tag', function () {
    let new_id_num = $(this).val();

    $.ajax({
        type: 'GET',
        url: "../includes/process.php?new_id_num=" + new_id_num,
        success: (response) => {
            let res = JSON.parse(response);
            if (res.status == 500) {
                // console.log("data no fetched");
            } else if (res.status == 200) {
                getID = res.data.ID;
                // console.log('success');
                // console.log(res.data.LastName);
                // console.log($('#updateFormRecord').attr('id'))
                // $('#editRecordModal')[0].reset();
                $('#updateFormRecord').attr("id", "AddToMasterlist");
                // console.log($('#AddToMasterlist').attr('id'))
                // console.log(getID);
                $('#updbtn').text('');
                $('#updbtn').text('ADD TO MASTERLIST');
                // $('#exampleModalLabel').text('');
                $('#exampleModalLabel').text('Add to Masterlist');
                $('#lastname').val(res.data.LastName);
                $('#firstname').val(res.data.FirstName);
                $('#middlename').val(res.data.MiddleName);
                $('#suffix').val(res.data.Suffix);
                if (res.editable === 'yes') {
                    $('#areaofoperation').append($('<option />').val(res.data.AreaOfOperation).text(res.data.AreaOfOperation).prop('selected', true).prop("hidden", true));
                } else if (res.editable === 'no') {
                    $('#areaofoperation').append($('<option />').val(res.data.AreaOfOperation).text(res.data.AreaOfOperation).prop('selected', true));
                    $('#areaofoperation').prop("disabled", true);
                }
                // console.log(res.editable);
                $('#address').val(res.data.Address);
                $('#addintdiv').prop('hidden', true);
                $('#editRecordModal').modal('show');



            }
        }
    })
})

$(document).on('submit', '#AddToMasterlist', function (e) {
    e.preventDefault();
    let formdata = new FormData(this);
    formdata.append('add_to_masterlist', true);


    $.ajax({
        method: 'POST',
        url: "../includes/process.php",
        data: formdata,
        processData: false,
        contentType: false,
        success: (response) => {
            let res = jQuery.parseJSON(response);
            // console.log(res.message);
            if (res.status == 200) {
                alertify.set('notifier', 'position', 'top-right');
                alertify.success(res.message);

                // let id = res.data.ID;
                $.ajax({
                    type: 'POST',
                    url: "../includes/process.php",
                    data: { id_num: getID },
                    success: function (response) {
                        let res = jQuery.parseJSON(response);
                        if (res.status == 200) {
                            // console.log(res.message);
                            $('#editRecordModal').modal('hide');
                        }
                        // $('#data-table').load(' #data-table');
                        // location.reload(true)
                        // table();

                    }
                });

                // Close the modal

                $('#editRecordModal').on('hidden.bs.modal', function () {
                    table();
                    $(this).off('hidden.bs.modal');
                }).modal('hide');
            }
        }
    })
})


$(document).on('click', '#addtlintbtn', function () {
    int_id = $(this).val();
    existingint(int_id);
    // let id = $('#ldps_id').val();
    // $('#intervention_n').append($('<option />').val('1').text('a').prop('selected', true).prop("hidden", true));

    // $.ajax({
    //     type: "GET",
    //     url: "../includes/process.php?add_int_id=" + int_id,
    //     success: (response) => {
    //         let res = JSON.parse(response);
    //         if (res.status == 200) {
    //             console.log(int_id);
    //             console.log(res.status);

    //             let data = res.data;
    //             let formbody = $('#allint');
    //             formbody.empty();

    //             data.forEach(item => {
    //                 let fields = `<div class="col-md-5">
    //                                     <select class="form-select pt-0" name="intervention" id="intervention_r" data-search="true"
    //                                         required>
    //                                         <option value="${item.intervention_id}" selected>${item.intervention_name}</option>
    //                                     </select>
    //                                 </div> 
    //                                 <div class="col-md-3">

    //                                         <input type="date" value="${item.DateAdmitted}" class="form-control" style="text-transform: lowercase;" id="dateadmitted"
    //                                         name="dateadmitted" min="2000-01-01" required>

    //                                 </div>
    //                                 <div class="col-md-3">

    //                                 <input type="date" value="${item.DateGraduated}" class="form-control" style="text-transform: lowercase;" id="dategrad"
    //                                     name="dategrad" min="2000-01-01">

    //                                 </div>
    //                                 <div class="col-md-1">

    //                                     <button class="btn btn-link form-control" type="submit">
    //                                         <i class="bi bi-pencil-square" style="font-size: 1.5em; margin-bottom: 15px;"></i>
    //                                     </button>
    //                                 </div> 
    //                                 <hr style="border: none;">`;
    //                 formbody.append(fields);
    //             });
    //         } else if (res.status == 500) {
    //             console.log(res.status);
    //             $('#intervention_r').text('');
    //             $('#dategrad').val('');
    //             $('#dateadmitted').text('');

    //         }
    //     }
    // })
    // console.log(id);
    // addInt(id);
    $('#addtlintmo').modal('show');
})

$(document).on('submit', '#addtlint', function (e) {
    e.preventDefault();
    let formdata = new FormData(this);

    formdata.append('add_new_int', true);
    $.ajax({
        method: 'POST',
        url: "../includes/process.php",
        data: formdata,
        processData: false,
        contentType: false,
        success: (response) => {
            let res = jQuery.parseJSON(response);
            // console.log(res.message);
            if (res.status == 200) {
                alertify.set('notifier', 'position', 'top-right');
                alertify.success(res.message);
                $('#addtlint')[0].reset();
                existingint(int_id);
                // $('#existingint').load(location.href + " #existingint");
            } else if (res.status == 500) {
                alertify.set('notifier', 'position', 'top-right');
                alertify.error(res.message);
            }
        }
    })

})


$(document).on('click', '#updtaddintbtn', function (e) {
    e.preventDefault();
    // let formdata = new FormData(this);
    // formdata.append("updateaddint", true);
    let edit_id = $(this).val();


    let form = $(this).closest('form');

    let formdata = new FormData(form[0]); // Get the first (and only) form in the jQuery object
    formdata.append("updateaddint", true);

    // console.log(edit_id);
    // console.log(formdata);

    $.ajax({
        type: 'POST',
        url: '../includes/process.php',
        data: formdata,
        processData: false,
        contentType: false,
        success: function (response) {
            let res = JSON.parse(response);
            if (res.status == 200) {
                alertify.set('notifier', 'position', 'top-right');
                alertify.success(res.message);
            } else {
                alertify.set('notifier', 'position', 'top-right');
                alertify.error(res.message);
            }
        }

    })
})

$(document).on('submit', '#change_pass', function (e) {
    e.preventDefault();
    let formdata = new FormData(this);
    formdata.append('change_password', true);
    $.ajax({
        type: 'POST',
        url: '../includes/process.php',
        data: formdata,
        processData: false,
        contentType: false,
        success: function (response) {
            let res = JSON.parse(response);
            if (res.status == 400) {
                alertify.set('notifier', 'position', 'top-right');
                alertify.error(res.message);
            } else if (res.status == 401) {
                alertify.set('notifier', 'position', 'top-right');
                alertify.error(res.message);
            } else if (res.status == 200) {
                Swal.fire({
                    position: 'center',
                    icon: 'success',
                    title: 'Password Successfully Change',
                    // confirmButtonText: 'Ok',
                    showConfirmButton: false,
                    timer: 1000
                }).then((result) => {
                    if (result.isConfirmed) {
                        $('#search').click();
                    }
                });
            }
        }
    });

});

$(document).on('submit', '#dashboardCount', function (e) {
    e.preventDefault();

    let datefrom = $('#datefrom').val();
    let dateuntil = $('#dateuntil').val();


    // 2nd AJAX call for total count (after chart renders)
    $.ajax({
        type: 'GET',
        url: '../includes/process.php',
        data: {
            pwud_Total: true,
            datefrom: datefrom,
            dateuntil: dateuntil
        },
        dataType: 'json',
        success: function (res) {
            if (res[0] && res[0].total !== undefined) {
                $('#totalCountDisplay').text(res[0].total);
            } else {
                console.error("Unexpected total response:", res);
            }
        },
        error: function (xhr, status, error) {
            console.error("AJAX Error:", status, error);
        }
    });


    // 1st AJAX call for chart data
    $.ajax({
        type: 'GET',
        url: '../includes/process.php',
        data: {
            dashboard_Count: true,
            datefrom: datefrom,
            dateuntil: dateuntil
        },
        success: function (response) {
            let categories = [];
            let userData = [];
            let pusherData = [];
            let bothData = [];
            let neitherData = [];

            try {
                let res = JSON.parse(response);

                res.forEach(row => {
                    categories.push(row.age_group);
                    userData.push(parseInt(row.user_only));
                    pusherData.push(parseInt(row.pusher_only));
                    bothData.push(parseInt(row.both_user_pusher));
                    neitherData.push(parseInt(row.neither));
                });

                // Chart after parsing success
                Highcharts.chart('container', {
                    chart: {
                        type: 'bar'
                    },
                    title: {
                        text: 'People Who Use Drugs By Age Group'
                    },
                    xAxis: {
                        categories: categories
                    },
                    yAxis: {
                        type: 'logarithmic',
                        title: {
                            text: 'Number of People'
                        },
                        minorTickInterval: 1
                    },
                    series: [
                        { name: 'User Only', data: userData },
                        { name: 'Pusher Only', data: pusherData },
                        { name: 'Both User & Pusher', data: bothData },
                        { name: 'Neither', data: neitherData }
                    ]
                });

            } catch (e) {
                console.error("Invalid JSON from dashboard_Count:", response);
                return;
            }


        }
    });
});

