CREATE DATABASE `acdaps` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;


CREATE TABLE `Barangay` (
  `ID` int unsigned NOT NULL AUTO_INCREMENT,
  `Barangay` varchar(15) NOT NULL,
  PRIMARY KEY (`ID`)
)



-- CREATE TABLE `ldps` (
--   `ID` int NOT NULL AUTO_INCREMENT,
--   `LastName` varchar(50) NOT NULL,
--   `FirstName` varchar(50) NOT NULL,
--   `MiddleName` varchar(50) NOT NULL,
--   `Suffix` varchar(5) NOT NULL,
--   `FullName` varchar(100) NOT NULL,
--   `Alias` varchar(50) NOT NULL,
--   `Address` varchar(200) NOT NULL,
--   `Hometown` varchar(50) NOT NULL,
--   `DateOfBirth` date NOT NULL,
--   `PlaceOfBirth` varchar(50) NOT NULL,
--   `Sex` varchar(10) NOT NULL,
--   `Religion` varchar(2) NOT NULL,
--   `CivilStatus` varchar(2) NOT NULL,
--   `Education` varchar(2) NOT NULL,
--   `Nationality` varchar(3) NOT NULL,
--   `ContactNo` varchar(20) NOT NULL,
--   `Employment` varchar(20) NOT NULL,
--   `FamilyIncome` int NOT NULL,
--   `Father` varchar(50) NOT NULL,
--   `Mother` varchar(50) NOT NULL,
--   `Spouse` varchar(50) NOT NULL,
--   `NoOfChildred` int NOT NULL,
--   `DateSurrendered` date NOT NULL,
--   `AreaOfOperation` varchar(20) NOT NULL,
--   `CaseStatus` varchar(50) NOT NULL,
--   `ActivityUser` tinyint(1) NOT NULL,
--   `ActivityPusher` tinyint(1) NOT NULL,
--   `WatchListed` tinyint(1) NOT NULL,
--   PRIMARY KEY (`ID`)
-- )
CREATE TABLE `LDPS` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `LastName` varchar(50) NOT NULL,
  `FirstName` varchar(50) NOT NULL,
  `MiddleName` varchar(50) NOT NULL,
  `Suffix` varchar(5) NOT NULL,
  `FullName` varchar(100) NOT NULL,
  `Alias` varchar(50) NOT NULL,
  `Address` varchar(200) NOT NULL,
  `Hometown` varchar(50) NOT NULL,
  `DateOfBirth` date NOT NULL,
  `PlaceOfBirth` varchar(50) NOT NULL,
  `Sex` varchar(10) NOT NULL,
  `Religion` varchar(2) NOT NULL,
  `CivilStatus` varchar(50) NOT NULL,
  `Education` varchar(2) NOT NULL,
  `Nationality` varchar(3) NOT NULL,
  `ContactNo` varchar(20) NOT NULL,
  `Employment` varchar(20) NOT NULL,
  `FamilyIncome` int NOT NULL,
  `Father` varchar(50) NOT NULL,
  `Mother` varchar(50) NOT NULL,
  `Spouse` varchar(50) NOT NULL,
  `NoOfChildred` int DEFAULT NULL,
  `DateSurrendered` date DEFAULT NULL,
  `AreaOfOperation` varchar(20) NOT NULL,
  `CaseStatus` varchar(50) DEFAULT NULL,
  `ActivityUser` varchar(2) NOT NULL,
  `ActivityPusher` varchar(2) DEFAULT NULL,
  `Status` varchar(2) NOT NULL,
  `WatchListed` varchar(2) NOT NULL,
  `Category` varchar(2) DEFAULT NULL,
  `Intervention` varchar(2) DEFAULT NULL,
  `DateAdmitted` date DEFAULT NULL,
  `DateGraduated` date DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `fk_cs_idx` (`CivilStatus`)
)

-- use acdaps;

CREATE TABLE Education (
educational_attainment_id INT NOT NULL AUTO_INCREMENT,
educational_attainment_name VARCHAR(50),
PRIMARY KEY(educational_attainment_id)
);


CREATE TABLE LivingArrangement (
living_arrangement_id INT NOT NULL AUTO_INCREMENT,
living_arrangement_name VARCHAR(50),
PRIMARY KEY(living_arrangement_id)
);


CREATE TABLE Nationality (
nationality_id INT NOT NULL AUTO_INCREMENT,
nationality_name VARCHAR(50),
PRIMARY KEY(nationality_id)
);



CREATE TABLE Religion (
religion_id INT NOT NULL AUTO_INCREMENT,
religion_name VARCHAR(50),
PRIMARY KEY(religion_id)
);



CREATE TABLE CivilStatus (
civil_status_id INT NOT NULL AUTO_INCREMENT,
civil_status_name VARCHAR(50),
PRIMARY KEY(civil_status_id)
);

CREATE TABLE Type (
id INT NOT NULL AUTO_INCREMENT,
type VARCHAR(50),
PRIMARY KEY(id)
);

CREATE TABLE `CaseStatus` (
  `case_status_id` int NOT NULL AUTO_INCREMENT,
  `case_status` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`case_status_id`)
) 



CREATE TABLE Category (
category_id INT NOT NULL AUTO_INCREMENT,
category_name VARCHAR(50),
PRIMARY KEY(category_id)
);

CREATE TABLE Intervention (
intervention_id INT NOT NULL AUTO_INCREMENT,
intervention_name VARCHAR(100),
PRIMARY KEY(intervention_id)
);

-- CREATE TABLE Status (
-- status_id INT NOT NULL AUTO_INCREMENT,
-- status_name VARCHAR(50),
-- PRIMARY KEY(status_id)
-- )
CREATE TABLE `Status` (
  `status_id` int NOT NULL AUTO_INCREMENT,
  `status_name` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`status_id`)
) 



INSERT INTO acdaps.civilstatus (civil_status_name) VALUES
('Single'),
('Married'),
('Common-law'),
('Separated'),
('Widow/er'),
('Annulled');



INSERT INTO acdaps.religion (religion_name) VALUES
('Roman Catholic'),
('Born Again Christian'),
('Protestant'),
('Iglesia ni Cristo'),
('7th Day Adventist'),
('Methodist'),
('Baptist'),
('Jehovah''s Witness'),
('Islam'),
('Aglipay'),
('Mormons'),
('Atheist/Agnostic'),
('Church of Latter Day Saints'),
('Dating Daan'),
('Others');

INSERT INTO acdaps.nationality (nationality_name) VALUES
('Afghan'),
('Albanian'),
('Algerian'),
('American'),
('Andorran'),
('Angolan'),
('Argentine'),
('Armenian'),
('Aromanian'),
('Aruban'),
('Australian'),
('Austrian'),
('Azerbaijani'),
('Bahamian'),
('Bahraini'),
('Bangladeshi'),
('Barbadian'),
('Basotho'),
('Basque'),
('Belarusian'),
('Belgian'),
('Belizean'),
('Bermudian'),
('Boer'),
('Bosniak'),
('Brazilian'),
('Breton'),
('British'),
('British Virgin Islander'),
('Bruneian'),
('Bulgarian'),
('Macedonian Bulgarian'),
('Burkinabè'),
('Burundian'),
('Cambodian'),
('Cameroonian'),
('Canadian'),
('Catalan'),
('Cape Verdean'),
('Chadian'),
('Chilean'),
('Chinese'),
('Colombian'),
('Comorian'),
('Congolese'),
('Croatian'),
('Cuban'),
('Cypriot'),
('Turkish Cypriot'),
('Czech'),
('Dane'),
('Dominicans (Republic)'),
('Dominicans (Commonwealth)'),
('Dutch'),
('East Timorese'),
('Ecuadorian'),
('Egyptian'),
('Emirati'),
('English'),
('Eritrean'),
('Estonian'),
('Ethiopian'),
('Falkland Islander'),
('Faroese'),
('Finn'),
('Finnish Swedish'),
('Fijian'),
('Filipino'),
('French citizen'),
('Georgian'),
('German'),
('Baltic German'),
('Ghanaian'),
('Gibraltar'),
('Greek'),
('Greek Macedonian'),
('Grenadian'),
('Guatemalan'),
('Guianese (French)'),
('Guinean'),
('Guinea-Bissau national'),
('Guyanese'),
('Haitian'),
('Honduran'),
('Hong Kong'),
('Hungarian'),
('Icelander'),
('I-Kiribati'),
('Indian'),
('Indonesian'),
('Iranian'),
('Iraqi'),
('Irish'),
('Israeli'),
('Italian'),
('Ivoirian'),
('Jamaican'),
('Japanese'),
('Jordanian'),
('Kazakh'),
('Kenyan'),
('Korean'),
('Kosovar'),
('Kurd'),
('Kuwaiti'),
('Kyrgyz'),
('Lao'),
('Latvian'),
('Lebanese'),
('Liberian'),
('Libyan'),
('Liechtensteiner'),
('Lithuanian'),
('Luxembourger'),
('Macao'),
('Macedonian'),
('Malagasy'),
('Malaysian'),
('Malawian'),
('Maldivian'),
('Malian'),
('Maltese'),
('Manx'),
('Mauritian'),
('Mexican'),
('Moldovan'),
('Moroccan'),
('Mongolian'),
('Montenegrin'),
('Namibian'),
('Nepalese'),
('New Zealander'),
('Nicaraguan'),
('Nigerien'),
('Nigerian'),
('Norwegian'),
('Pakistani'),
('Palauan'),
('Palestinian'),
('Panamanian'),
('Papua New Guinean'),
('Paraguayan'),
('Peruvian'),
('Pole'),
('Portuguese'),
('Puerto Rican'),
('Quebecer'),
('Réunionnai'),
('Romanian'),
('Russian'),
('Baltic Russian'),
('Rwandan'),
('Salvadoran'),
('São Tomé and Príncipe'),
('Saudi'),
('Scot'),
('Senegalese'),
('Serb'),
('Sierra Leonean'),
('Singaporean'),
('Sindhian'),
('Slovak'),
('Slovene'),
('Somali'),
('Somalilander'),
('South African'),
('Spaniard'),
('Sri Lankan'),
('St Lucian'),
('Sudanese'),
('Surinamese'),
('Swede'),
('Swi'),
('Syriac'),
('Syrian'),
('Tajik'),
('Taiwanese'),
('Tanzanian'),
('Thai'),
('Tibetan'),
('Tobagonian'),
('Trinidadian'),
('Tunisian'),
('Turk'),
('Tuvaluan'),
('Ugandan'),
('Ukrainian'),
('Uruguayan'),
('Uzbek'),
('Vanuatuan'),
('Venezuelan'),
('Vietnamese'),
('Welsh'),
('Yemeni'),
('Zambian'),
('Zimbabwean');



INSERT INTO acdaps.livingarrangement (living_arrangement_name) VALUES
('With Parents'),
('With Relatives/Guardian'),
('With Spouse '),
('With Children'),
('With Siblings'),
('With Friends'),
('With Live-in Partners'),
('Living Alone'),
('With co-workers'),
('With Orphans'),
('In the street');


INSERT INTO acdaps.education (educational_attainment_name) VALUES
('No Schooling'),
('Elementary Level'),
('Elementary Graduate'),
('Highschool Level'),
('Highschool Graduate'),
('College Level'),
('College Graduate'),
('Vocational/Technical'),
('Post-Graduate');


INSERT INTO acdaps.barangay (Barangay) VALUES 
('Bagong Nayon'),
('Beverly Hills'),
('Calawis'),
('Cupang'),
('Dalig'),
('Dela Paz'),
('Inarawan'),
('Mambugan'),
('Mayamot'),
('Muntindilao'),
('San Isidro'),
('San Jose'),
('San Juan'),
('San Luis'),
('San Roque'),
('Sta. Cruz');



INSERT INTO status (`status_id`, `status_name`) VALUES
(0, 'Delisted'),
(1, 'Listed')


INSERT INTO type (`type`) VALUES
('User'),
('Pusher'),
('Both');

INSERT INTO intervention (`intervention_name`) VALUES
('Treatment and Rehabilitation Facility (DOH-BICUTAN)'),
('After-Care'),
('Balay Silangan'),
('Community Based (CBDRP)'),
('General Intervention');

CREATE TABLE add_intervention (
    ID INT NOT NULL AUTO_INCREMENT,
    ldps_id INT NOT NULL,
    Intervention VARCHAR(50),
    DateAdmitted DATE,
    DateGraduated DATE,
    PRIMARY KEY (ID)
);