<?php


include '../class/classes.php';

if (!isset($_SESSION['All'])) {
    if (!isset($_SESSION['Barangay'])) {
        header("location: ../index.php");
        exit();
    }
}

$connectClass = new Connection;
$con = $connectClass->dbConnect;

//1
if (isset($_GET['id_num'])) {
    $record_id = mysqli_real_escape_string($con, $_GET['id_num']);

    // $query = "SELECT * FROM LDPS WHERE id='$record_id'";
    $query = "SELECT *
    FROM LDPS
    LEFT JOIN CivilStatus
    ON LDPS.CivilStatus = CivilStatus.civil_status_id
    LEFT JOIN Education
    ON LDPS.Education = Education.educational_attainment_id
    LEFT JOIN Religion
    ON LDPS.Religion = Religion.religion_id
    LEFT JOIN Nationality
    ON LDPS.Nationality = Nationality.nationality_id
    -- LEFT JOIN CaseStatus
    -- ON LDPS.CaseStatus = CaseStatus.case_status_id
    LEFT JOIN Category
    ON LDPS.Category = Category.category_id
    LEFT JOIN Intervention
    ON LDPS.Intervention = Intervention.intervention_id
    LEFT JOIN Status
    ON LDPS.Status = Status.status_id
    WHERE ID = $record_id";

    $query_run = mysqli_query($con, $query);

    if (mysqli_num_rows($query_run) === 1) {
        $record = mysqli_fetch_array($query_run);

        $res = [
            'status' => 200,
            'message' => 'Record Fetch Successfully by id',
            'data' => $record
        ];
        echo json_encode($res);
        return;
    } else {
        $res = [
            'status' => 404,
            'message' => 'Record Id Not Found'
        ];
        echo json_encode($res);
        return;
    }
}



//2
if (isset($_POST['update_record'])) {
    $id = mysqli_real_escape_string($con, $_POST['id']);
    // $name = mysqli_real_escape_string($con, $_POST['name']);
    // $email = mysqli_real_escape_string($con, $_POST['email']);
    // $phone = mysqli_real_escape_string($con, $_POST['phone']);
    // $course = mysqli_real_escape_string($con, $_POST['course']);
    $lastname = ucwords(mysqli_real_escape_string($con, $_POST['lastname']));
    $firstname = ucwords(mysqli_real_escape_string($con, $_POST['firstname']));
    $middlename = ucwords(mysqli_real_escape_string($con, $_POST['middlename']));
    $fullname = $lastname . ", " . $firstname . " " . $middlename;
    $suffix = ucwords(mysqli_real_escape_string($con, $_POST['suffix']));
    $alias = ucwords(mysqli_real_escape_string($con, $_POST['alias']));
    // $dateofbirth = mysqli_real_escape_string($con, $_POST['dateofbirth']);
    $dateofbirth = empty($_POST['dateofbirth']) ? null : $_POST['dateofbirth'];
    $placeofbirth = mysqli_real_escape_string($con, $_POST['placeofbirth']);
    $gender = mysqli_real_escape_string($con, $_POST['gender']);
    $nationality = mysqli_real_escape_string($con, $_POST['nationality']);
    $religion = mysqli_real_escape_string($con, $_POST['religion']);
    $address = ucwords(mysqli_real_escape_string($con, $_POST['address']));
    if (isset($_SESSION['Barangay'])) {
        $areaofoperation = $_SESSION['Barangay'];
    } elseif (isset($_SESSION['All'])) {
        $areaofoperation = $_POST['areaofoperation'];
    }
    // $areaofoperation = mysqli_real_escape_string($con, $_POST['areaofoperation']);
    $hometown = ucwords(mysqli_real_escape_string($con, $_POST['hometown']));
    $civilstatus = mysqli_real_escape_string($con, $_POST['civilstatus']);
    $contactno = mysqli_real_escape_string($con, $_POST['contactno']);
    $noofchild = mysqli_real_escape_string($con, $_POST['noofchildren']);
    $education = mysqli_real_escape_string($con, $_POST['education']);
    $employment = ucwords(mysqli_real_escape_string($con, $_POST['employment']));
    $familyincome = mysqli_real_escape_string($con, $_POST['familyincome']);
    $spouse = ucwords(mysqli_real_escape_string($con, $_POST['spouse']));
    $father = ucwords(mysqli_real_escape_string($con, $_POST['father']));
    $mother = ucwords(mysqli_real_escape_string($con, $_POST['mother']));
    $datesurrendered = mysqli_real_escape_string($con, $_POST['datesurrendered']);
    $casestatus = $_POST['casestatus'];
    $drugused = ucwords($_POST['drugused']);
    // $activityuser = mysqli_real_escape_string($con, $_POST['activityuser']);
    // $activitypusher = mysqli_real_escape_string($con, $_POST['activitypusher']);
    if (!isset($_POST['user'])) {
        $activityuser = 0;
    } else {
        $activityuser = $_POST['user'];
    }

    if (!isset($_POST['pusher'])) {
        $activitypusher = 0;
    } else {
        $activitypusher = $_POST['pusher'];
    }

    if (!isset($_POST['status'])) {
        $status = null;
    } else {
        $status = $_POST['status'];
    }

    $category = $_POST['category'];
    if (!isset($_POST['intervention'])) {
        $intervention = null;
    } else {
        $intervention = $_POST['intervention'];
    }

    if (empty($familyincome)) {
        $familyincome = 0;
    }

    if (empty($noofchild)) {
        $noofchild = 0;
    }

    // if (!isset($_POST['watchlisted']) || empty($_POST['watchlisted'])) {
    //     $watchlisted = null;
    // } else {
    //     $watchlisted = $_POST['watchlisted'];
    // }

    if (isset($_POST['watchlistedYES'])) {
        $watchlisted = $_POST['watchlistedYES'];
    }

    if (isset($_POST['watchlistedNO'])) {
        $watchlisted = $_POST['watchlistedNO'];
    }

    if (!isset($_POST['watchlistedYES']) && !isset($_POST['watchlistedNO'])) {
        $watchlisted = 0;
    }

    if (!isset($_POST['dateadmitted']) || empty($_POST['dateadmitted'])) {
        $dateadmitted = null;
    } else {
        $dateadmitted = $_POST['dateadmitted'];
    }

    if (!isset($_POST['dategrad']) || empty($_POST['dategrad'])) {
        $dategrad = null;
    } else {
        $dategrad = $_POST['dategrad'];
    }
    $Remarks = mysqli_real_escape_string($con, $_POST['remarks']);

    if ($lastname === NULL || $firstname === NULL || $middlename === NULL) {
        $res = [
            'status' => 422,
            'message' => 'All fields are mandatory'
        ];
        echo json_encode($res);
        return;
    }

    // $query = "UPDATE LDPS SET name='$name', email='$email', phone='$phone', course='$course' 
    //             WHERE id='$record_id'";
    if (!isset($_POST['datesurrendered']) || empty($_POST['datesurrendered'])) {
        $query = "UPDATE LDPS SET LastName = ?, FirstName = ?, MiddleName = ?, 
        Suffix = ?, FullName = ?, Alias = ?, Address = ?, Hometown = ?, 
        DateOfBirth = ?, PlaceOfBirth = ?, Sex = ?, Religion = ?, 
        CivilStatus = ?, Education = ?,
        Nationality = ?, ContactNo = ?, Employment = ?, FamilyIncome = ?, 
        Father = ?, Mother = ?, Spouse = ?, NoOfChildred = ?, DrugUsed = ?,
        AreaOfOperation = ?, CaseStatus = ?, ActivityUser = ?, 
        ActivityPusher = ?, Status = ?, WatchListed = ?, Category = ?, 
        Intervention = ?, DateAdmitted = ?, DateGraduated = ?, Remarks = ? WHERE ID = ?";


        // Prepare the statement
        $stmt = $con->prepare($query);

        // Bind parameters to the prepared statement
        $stmt->bind_param(
            "sssssssssssssssssssssssssssssssssss",
            $lastname,
            $firstname,
            $middlename,
            $suffix,
            $fullname,
            $alias,
            $address,
            $hometown,
            $dateofbirth,
            $placeofbirth,
            $gender,
            $religion,
            $civilstatus,
            $education,
            $nationality,
            $contactno,
            $employment,
            $familyincome,
            $father,
            $mother,
            $spouse,
            $noofchild,
            $drugused,
            $areaofoperation,
            $casestatus,
            $activityuser,
            $activitypusher,
            $status,
            $watchlisted,
            $category,
            $intervention,
            $dateadmitted,
            $dategrad,
            $Remarks,
            $id
        );
    } else {
        $query = "UPDATE LDPS SET LastName = ?, FirstName = ?, MiddleName = ?, 
        Suffix = ?, FullName = ?, Alias = ?, Address = ?, Hometown = ?, 
        DateOfBirth = ?, PlaceOfBirth = ?, Sex = ?, Religion = ?, 
        CivilStatus = ?, Education = ?,
        Nationality = ?, ContactNo = ?, Employment = ?, FamilyIncome = ?, 
        Father = ?, Mother = ?, Spouse = ?, NoOfChildred = ?, 
        DateSurrendered = ?, DrugUsed = ?, AreaOfOperation = ?, CaseStatus = ?, 
        ActivityUser = ?, ActivityPusher = ?, Status = ?, 
        WatchListed = ?, Category = ?, Intervention = ?, DateAdmitted = ?, DateGraduated = ?, Remarks = ? WHERE ID = ?";

        // Prepare the statement
        $stmt = $con->prepare($query);

        // Bind parameters to the prepared statement
        $stmt->bind_param(
            "ssssssssssssssssssssssssssssssssssss",
            $lastname,
            $firstname,
            $middlename,
            $suffix,
            $fullname,
            $alias,
            $address,
            $hometown,
            $dateofbirth,
            $placeofbirth,
            $gender,
            $religion,
            $civilstatus,
            $education,
            $nationality,
            $contactno,
            $employment,
            $familyincome,
            $father,
            $mother,
            $spouse,
            $noofchild,
            $datesurrendered,
            $drugused,
            $areaofoperation,
            $casestatus,
            $activityuser,
            $activitypusher,
            $status,
            $watchlisted,
            $category,
            $intervention,
            $dateadmitted,
            $dategrad,
            $Remarks,
            $id
        );
    }

    if ($stmt->execute()) {
        $ldpsID = $id;
        $login = new Login();


        $login->insertSnapshotLog($ldpsID, 'UPDATE');

        $res = [
            'status' => 200,
            'message' => 'Record Updated Successfully'
        ];
        echo json_encode($res);
        return;
    } else {
        $res = [
            'status' => 500,
            'message' => 'Failed to update record'
        ];
        echo json_encode($res);
        return;
    }


    // Execute the prepared statement
    // if ($stmt->execute()) {
    //     $res = [
    //         'status' => 200,
    //         'message' => 'Record Updated Successfully'
    //     ];
    //     echo json_encode($res);
    //     return;
    // } else {
    //     $res = [
    //         'status' => 500,
    //         'message' => 'Record Not Updated'
    //     ];
    //     echo json_encode($res);
    //     return;
    // }
}


// 3 add new
if (isset($_POST['add_new_pdea'])) {
    $addnewobj = new AddNewPDEA;
    $addnew = $addnewobj->addNewPDEARecord($_POST);
    echo json_encode($addnew);
}

// 4 Show lists
// $test = new TaggingList;
// $fortagging = $test->forTagging();
// echo json_encode($fortagging);

if (isset($_GET['new_id_num'])) {
    $id = $_GET['new_id_num'];
    $selectoneobj = new ToAdd;
    $selectone = $selectoneobj->addToMasterList($id);
    echo json_encode($selectone);
}

if (isset($_POST['add_to_masterlist'])) {
    $toMasterListObj = new AddToMasterList;
    $toMasterList = $toMasterListObj->addToMasterListDB($_POST['add_to_masterlist']);
    echo json_encode($toMasterList);
}

if (isset($_POST['id_num'])) {
    $toMasterListObj = new AddToMasterList;
    $updateTag = $toMasterListObj->updateTag($_POST['id_num']);
    echo json_encode($updateTag);
}

if (isset($_POST['add_new_int'])) {
    $addNewIntObj = new AddIntervention;
    $addNewInt = $addNewIntObj->addNewInt($_POST['add_new_int']);
    echo json_encode($addNewInt);
}

if (isset($_GET['add_int_id'])) {
    $getAddIntObj = new AllInterventions;
    $getAddInt = $getAddIntObj->interventionsLists($_GET['add_int_id']);
    echo json_encode($getAddInt);
}

if (isset($_POST['updateaddint'])) {
    $updtAddIntObj = new UpdtAddInt;
    $updtAddInt = $updtAddIntObj->updateInt();
    echo json_encode($updtAddInt);
}

if (isset($_POST['new_password'])) {
    $changepassobj = new ChangePassword;
    $changepass = $changepassobj->changepass($_POST['new_password']);
    echo json_encode($changepass);
}
if (isset($_GET['dashboard_Count'])) {
    $dashboardObj = new PWUDDashBoard;
    echo json_encode($dashboardObj->pwudDashboardCount($_GET));
    exit;
}

if (isset($_GET['pwud_Total'])) {
    $dashboardtotalCount = new PWUDDashBoard;
    echo json_encode($dashboardtotalCount->pwudTotalCount($_GET));
    exit;
}







